<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CSitemaps extends CPlugin{	
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == $this->name) {

			//$this->__init();
			//$this->plugins["globalhooks"]->SetModule($this->tpl_module);

			switch ($_GET["sub"]) {

				case "landing":
					return $this->Sitemap();
				break;

				case "sitemap":
					return $this->GoogleMap();
				break;
				
			}
		}		

	}

	function GoogleMap() {
		set_time_limit(0);
		//get all the modules
		$links = $this->read_links();

		global $_CONF;

		if (is_array($links)) {
			foreach ($links as $key => $val) {
				if ($val["lastmod"]) {
					$links[$key]["lastmod"]  = "<lastmod>" . date("Y-m-d" , $val["lastmod"]) . "</lastmod>";
				} else {
					$links[$key]["lastmod"]  = "";
				}

				if ($val["priority"]) {
					$links[$key]["priority"]  = "<priority>" . $val["priority"] . "</priority>";
				} else {
					$links[$key]["priority"]  = "";
				}
				
			}
		}

		global $base;

		//$this->module->plugins["modules"]->MimeXML();
		$mime = new CMime();
		$mime->Set("xml");
		header("X-Robots-Tag: noindex, nofollow");

		$template = new CTemplateDynamic($this->tpl_path . "sitemap.xml");

		return $base->html->table(
			$template , 
			"Map" ,
			$links
		);
	}	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SiteMap() {
		global $_CONF , $_TSM , $_LANG_RAW;
		//check if the site is multilanguage

			$this->plugins["languages"]->LoadLanguages();
			$languages = $this->plugins["languages"]->languages;


		if (!$this->vars->data["set_multilanguage"]) {

			$languages = array($_LANG_RAW);
		}

		$instance_mods = explode("," , $this->vars->data["set_sitemap_modules"]);
		$global_mods = explode("," , $this->vars->data["set_sitemap_modules_global"]);

		if (is_array($instance_mods)) {
			foreach ($instance_mods as $key => $val) {
				if (trim($val)) {
					$index[] =	$val;
				}				
			}			
		}

		if (is_array($global_mods)) {
			foreach ($global_mods as $key => $val) {
				if (trim($val)) {
					$index[] =	$val;
				}				
			}			
		}
		
		switch ($this->vars->data["set_sitemap_default"]) {
			//all modules
			default:
				$modules = $this->plugins["modules"]->modules;
			break;

			//specific modules
			case "2":
				if (is_array($index) && count($index)) {
					foreach ($this->plugins["modules"]->modules as $key => $val) {
						if (in_array($key , $index)) {
							$modules[$key] = $val;
						}						
					}										
				}				
			break;

			//all except modules
			case "3":
				foreach ($this->plugins["modules"]->modules as $key => $val) {
					if (!in_array($key , $index)) {
						$modules[$key] = $val;
					}						
				}										
			break;
		}		


		$lang = $languages[key($languages)];

		if (is_array($modules)) {
			foreach ($modules as $module) {

				if (!$module["module_protected"] && method_exists($this->plugins[$module["module_code"]] , "SitemapGetMaps")) {					

					if (!$this->vars->data["set_multilanguage"] && (count($languages) > 1)) {
						foreach ($languages as $language) {

							if ($language["lang_status"] == "1") {
								$tmp = $this->plugins[$module["module_code"]]->SitemapGetMaps($module , $language);

								if (is_array($tmp) && count($tmp)) {
									foreach ($tmp as $k => $v) {
										$sitemaps[] = array(
											"url" => $this->encodeUrl($_CONF["url"] . $language["lang_code"] . "/sitemap-xml/" . $k . ".xml" . (is_array($v) ? "?" . http_build_query($v) : "")),
											"module" => $this->encodeUrl($module["mod_name"] ? $module["mod_name"] : $module["module_name"]),
										);
									}								
								}							
							}							
						}
					} else {
						$tmp = $this->plugins[$module["module_code"]]->SitemapGetMaps($module , $lang);

						if (is_array($tmp) && count($tmp)) {
							foreach ($tmp as $k => $v) {
								$sitemaps[] = array(
									"url" => $this->encodeUrl($_CONF["url"] . "sitemap-xml/" . $k . ".xml" . (is_array($v) ? "?" . http_build_query($v) : "")),
									"module" => $this->encodeUrl($module["mod_name"] ? $module["mod_name"] : $module["module_name"]),
								);
							}								
						}							

					}
				}
			}			
		}		

		global $base;


		//$this->module->plugins["modules"]->MimeXML();
		$mime = new CMime();
		$mime->Set("xml");
		header("X-Robots-Tag: noindex, nofollow");

		$template = new CTemplateDynamic($this->tpl_path . "sitemaps.xml");

		return $base->html->table(
			$template , 
			"" ,
			$sitemaps
		);

	}
	

	function read_links() {
		global $_CONF;


		if (is_array($module = $this->plugins["modules"]->modules[$_GET["module"]])) {
			if (!$module["module_protected"] && method_exists($this->plugins[$module["module_code"]] , "SitemapGetLinks") ) {
				$this->module->plugins[$module["module_code"]]->SitemapGetLinks($module , $links);
			} elseif (!$module["module_protected"] && method_exists($this->plugins[$module["module_code"]] , "GetAllLinks") ) {
				$this->module->plugins[$module["module_code"]]->GetAllLinks($module , $links);
			}
		}

		return $links;
	}


	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function CronPingGoogle($job) {
		global $_CONF;

		$module = $this->plugins["modules"]->GetModuleByID($job["job_module"]);

		$url = "http://www.google.com/webmasters/sitemaps/ping?sitemap=" . urlencode("https://www.bangthebook.com/" . "sitemap.xml" );

		echo "Pinging google {$url} ... ";

		$data = CHTTP::NewInstance()
			->Get($url)->Raw();

		echo "done \n\n";

		echo strip_tags($data);

	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function encodeUrl($url) {
		return str_replace(
			array(
				"&",	
				"'",
				'"',
				">",
				"<"
			),
			array(
				"&amp;",
				"&apos;",
				"&quot;",
				"&gt;",
				"&lt;"

			),
			$url
		);
	}
	
}

?>